// Autor: Gustav Matula

#include <cstdio>
#include <cstring>
#include <cstdlib>
#include <cassert>

#include <set>
#include <map>
#include <vector>
#include <algorithm>
#include <functional>
#include <queue>

#include <sstream>
#include <iostream>

using namespace std;
typedef long long llint;
const llint inf = 1000000000000000000LL;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

const int MAXN = 2005;
const int dx[] = {1, 0, -1, 0};
const int dy[] = {0, 1, 0, -1};

void bfs01(char m[MAXN][MAXN], int a[MAXN][MAXN], int n, int x, int y) {
  memset(a, 0x3f, 4 * MAXN * MAXN);
  deque<pair<int,int>> q;
  q.push_back({x, y});
  a[x][y] = m[x][y] - '0';
  assert(a[x][y] == 0);

  while (!q.empty()) {
    int x, y;
    tie(x, y) = q.front(); q.pop_front();

    REP(d, 4) {
      int nx = x + dx[d];
      int ny = y + dy[d];
      if (nx < 0 || nx >= n) continue;
      if (ny < 0 || ny >= n) continue;
      if (a[x][y] + m[nx][ny] - '0' < a[nx][ny]) {
	a[nx][ny] = a[x][y] + m[nx][ny] - '0';
	if (m[nx][ny] == '0')
	  q.push_front({nx, ny});
	else
	  q.push_back({nx, ny});
      }
    }
  }
}

int solve(char m[MAXN][MAXN], int n, int k, int xa, int ya, int xb, int yb) {
  static int a[MAXN][MAXN];
  static int b[MAXN][MAXN];
  static int ma[MAXN];
  static int mb[MAXN];

  bfs01(m, a, n, xa, ya);
  bfs01(m, b, n, xb, yb);

  REP(i, n) {
    ma[i] = mb[i] = 1e9;
    REP(j, n) {
      ma[i] = min(ma[i], a[i][j]);
      mb[i] = min(mb[i], b[i][j]);
    }
  }

  int sol = 1e9;
  REP(i, n) {
    int csol = 0;
    if (i > 0) {
      if (xa <= i - 1) csol += ma[i - 1];
      if (xb <= i - 1) csol += mb[i - 1];
    }
    if (i + k < n) {
      if (xa >= i + k) csol += ma[i + k];
      if (xb >= i + k) csol += mb[i + k];
    }
    sol = min(sol, csol);
  }

  return sol;
}

int main(void) 
{
  static char m[MAXN][MAXN];

  int n;
  scanf("%d", &n);
  REP(i, n) scanf("%s", m[i]);

  int t;
  scanf("%d", &t);
  while (t--) {
    int k, xa, ya, xb, yb;
    scanf("%d%d%d%d%d", &k, &xa, &ya, &xb, &yb);
    --xa; --ya; --xb; --yb;
    printf("%d\n", solve(m, n, k, xa, ya, xb, yb)); 
  }

  return 0;
}
